#! /bin/sh
### BEGIN INIT INFO
# Provides:          noip2
# Required-Start:    $local_fs $remote_fs $network $syslog $named
# Required-Stop:     $local_fs $remote_fs $network $syslog $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start/stop cambioenlace
### END INIT INFO

#-----------este while es para que se ejecute para siempre
while test "1" = "1" 
do 

#defino el ip de la puerta de enlace

IP=$(/sbin/ip route | awk '/default/ { print $3 }')

#defino los 3 posibles gateways actuales
GW1="192.168.0.1"
GW2="192.168.0.2"
GW3="192.168.0.3"

#es importante tener el espacio antes y despues del corchete para que funcione
#para strings debe tener un solo igual y las variables entre comilla
#Si estoy en el 1, el proximo es el 3. Si estoy en el 3, el proximo es el 2. Si estoy en el 2, el proximo es el 1.
if [ "$IP" = "$GW1" ]; then 
NextGW="192.168.0.3"
elif [ "$IP" = "$GW3" ]; then
NextGW="192.168.0.2"
else
NextGW="192.168.0.1"
fi


if (ping -c 40 8.8.8.8 > /dev/null); then 

sleep 20 # Conectado. Espero 20 segundos, y luego se reinicia el loop.

else #Significa que no pudo pinguear en 50 veces. Cambio de puerta de enlace a la siguiente.

route del default
route add default gw $NextGW

fi #termina el chequeo del ping
done #--------------termina el while
